<?php
include '../includes/db.php';

$id_wakaf = $_GET['id'] ?? 0;
$wakaf = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM wakaf WHERE id='$id_wakaf'"));
if (!$wakaf) {
  echo "Program wakaf tidak ditemukan."; exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Form Donasi Wakaf</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body { font-family: sans-serif; background: #f4f4f4; padding: 30px; }
    .form-box {
      max-width: 500px; background: white; padding: 20px;
      margin: auto; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    h2 { text-align: center; color: #006400; font-size: 18px; margin-bottom: 20px; }
    input {
      width: 100%; padding: 10px; margin-bottom: 15px;
      border: 1px solid #ccc; border-radius: 6px;
    }
    button {
      width: 100%; background: #006400; color: white; padding: 10px;
      border: none; border-radius: 6px; font-weight: bold;
    }
  </style>
</head>
<body>

<div class="form-box">
  <h2>Donasi Wakaf: <?= htmlspecialchars($wakaf['judul']) ?></h2>
  <form id="wakafForm">
    <input type="hidden" name="id_wakaf" value="<?= $wakaf['id'] ?>">
    <label>Nama Lengkap</label>
    <input type="text" name="nama" required>

    <label>Nominal Donasi (Rp)</label>
    <input type="number" name="jumlah" required min="1000" step="1000">

    <button type="submit">KIRIM DONASI</button>
  </form>
</div>

<script>
document.getElementById('wakafForm').addEventListener('submit', function(e) {
  e.preventDefault();
  const form = e.target;
  const nama = form.nama.value;
  const jumlah = parseInt(form.jumlah.value).toLocaleString('id-ID');

  if (!nama || !jumlah) return;

  if (confirm(
    `Terima kasih, ${nama}!\n\nSilakan transfer ke:\nBANK KALBAR SYRAI'AH (BPD KALBAR UUS)\nNo. Rek: 882108105346\nA.n: Yayasan Impian Mulia Bersama\n\nJumlah: Rp ${jumlah}\n\nCatatan:\nJangan lupa Like, Komentar, dan Share yaa kak 😊\n\nSetelah transfer, klik OK untuk lanjut ke kirim ke admin.`)
  ) {
    form.action = 'proses_pembayaran_wakaf.php';
    form.method = 'POST';
    form.submit();
  }
});
</script>

</body>
</html>
