--TEST--
Test ImagickPixel, setColorValueQuantum
--SKIPIF--
<?php require_once(dirname(__FILE__) . '/skipif.inc'); ?>
--FILE--
<?php


function setColorValueQuantum() {
    $image = new Imagick();

    $quantumRange = $image->getQuantumRange();

    $draw = new ImagickDraw();
    $color = new ImagickPixel('blue');
    $color->setcolorValueQuantum(Imagick::COLOR_RED, 128 * $quantumRange['quantumRangeLong'] / 256);

    $draw->setstrokewidth(1.0);
    $draw->setStrokeColor($color);
    $draw->setFillColor($color);
    $draw->rectangle(200, 200, 300, 300);

    $image->newImage(500, 500, "SteelBlue2");
    $image->setImageFormat("png");

    $image->drawImage($draw);

    $bytes = $image->getImageBlob();
    if (strlen($bytes) <= 0) { echo "Failed to generate image.";} 
}

setColorValueQuantum() ;
echo "Ok";
?>
--EXPECTF--
Ok