<?php
require __DIR__ . '/includes/db.php';
include __DIR__ . '/includes/navbar.php';
$q=trim($_GET['q']??''); $min=(int)($_GET['min']??0); $max=(int)($_GET['max']??0);
$ymin=(int)($_GET['ymin']??0); $ymax=(int)($_GET['ymax']??0); $sort=$_GET['sort']??'newest';
$page=max(1,(int)($_GET['page']??1)); $perPage=12; $offset=($page-1)*$perPage;

$w=["l.status='published'","v.type='motorcycle'","v.condition_type='new'"];
if($q!==''){ $qEsc=mysqli_real_escape_string($conn,$q); $w[]="(l.title LIKE '%$qEsc%')"; }
if($min>0) $w[]="l.price >= $min"; if($max>0) $w[]="l.price <= $max";
if($ymin>0) $w[]="v.year >= $ymin"; if($ymax>0) $w[]="v.year <= $ymax";
$whereSql='WHERE '.implode(' AND ',$w);

$order="l.published_at DESC";
if($sort==='price_asc') $order="l.price ASC";
if($sort==='price_desc') $order="l.price DESC";
if($sort==='year_desc') $order="v.year DESC, l.published_at DESC";
if($sort==='year_asc') $order="v.year ASC, l.published_at DESC";

$total=(int)mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(1) c FROM listings l JOIN vehicles v ON v.id=l.vehicle_id $whereSql"))['c'];
$pages=max(1,(int)ceil($total/$perPage));
$sql="SELECT l.id,l.title,l.price,l.city,l.province,v.year,v.type,v.condition_type,
(SELECT url FROM vehicle_photos vp WHERE vp.vehicle_id=v.id AND vp.is_primary=1 ORDER BY sort_order LIMIT 1) photo
FROM listings l JOIN vehicles v ON v.id=l.vehicle_id
$whereSql ORDER BY $order LIMIT $perPage OFFSET $offset";
$res=mysqli_query($conn,$sql);
?>
<!doctype html><html lang="id"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Motor Baru | Cremoid</title>
<style><?php echo preg_replace('/<\/style>.*/s','', file_get_contents(__DIR__.'/mobil-baru.php')); ?></style></head><body>
<div class="hero" id="hero"><div class="hero-track">
  <section class="hero-slide"><img src="<?= e(ASSET_URL) ?>/img/slide-1.jpg" alt=""></section>
  <section class="hero-slide"><img src="<?= e(ASSET_URL) ?>/img/slide-2.jpg" alt=""></section>
  <section class="hero-slide"><img src="<?= e(ASSET_URL) ?>/img/slide-3.jpg" alt=""></section>
</div><button class="h-arrow h-prev" aria-label="Prev"><svg width="20" height="20" viewBox="0 0 24 24"><path d="M15.41 7.41 14 6l-6 6 6 6 1.41-1.41L10.83 12z"/></svg></button>
<button class="h-arrow h-next" aria-label="Next"><svg width="20" height="20" viewBox="0 0 24 24"><path d="m8.59 16.59 1.41 1.41 6-6-6-6-1.41 1.41L13.17 12z"/></svg></button>
<div class="h-dots" id="heroDots"></div></div>

<div class="container searchWrap">
  <form class="searchbar" method="get">
    <input type="text" name="q" value="<?= e($q) ?>" placeholder="Cari judul/merk/model">
    <input type="number" name="min" value="<?= e($min) ?>" placeholder="Harga min">
    <input type="number" name="max" value="<?= e($max) ?>" placeholder="Harga max">
    <input type="number" name="ymin" value="<?= e($ymin) ?>" placeholder="Tahun min">
    <input type="number" name="ymax" value="<?= e($ymax) ?>" placeholder="Tahun max">
    <select name="sort">
      <option value="newest" <?= $sort==='newest'?'selected':'' ?>>Terbaru</option>
      <option value="price_asc" <?= $sort==='price_asc'?'selected':'' ?>>Termurah</option>
      <option value="price_desc" <?= $sort==='price_desc'?'selected':'' ?>>Termahal</option>
      <option value="year_desc" <?= $sort==='year_desc'?'selected':'' ?>>Tahun terbaru</option>
      <option value="year_asc" <?= $sort==='year_asc'?'selected':'' ?>>Tahun terlama</option>
    </select>
    <button class="btn primary" type="submit">Terapkan</button>
  </form>
</div>

<div class="container section">
  <h2>Motor Baru</h2>
  <?php if(!$total): ?><div style="background:#fff;border:1px solid var(--line);border-radius:14px;padding:14px">Belum ada data.</div>
  <?php else: ?><div class="grid">
    <?php while($r=mysqli_fetch_assoc($res)): ?>
      <div class="card">
        <img src="<?= e($r['photo'] ?: ASSET_URL.'/img/demo-bike.jpg') ?>" alt="">
        <div class="b">
          <div style="margin-bottom:6px"><span class="pill">MOTORCYCLE</span><span class="pill">Baru</span><span class="pill"><?= (int)$r['year'] ?></span></div>
          <div style="font-weight:800;line-height:1.25"><?= e($r['title']) ?></div>
          <div class="price"><?= 'Rp'.number_format($r['price'],0,',','.') ?></div>
          <div style="font-size:12px;color:#667"><?= e(trim($r['city'].($r['province']?', '.$r['province']:''))) ?></div>
          <a class="btn detail" href="<?= e(url('/detail.php?id='.$r['id'])) ?>">Detail</a>
        </div>
      </div>
    <?php endwhile; ?>
  </div>
  <?php if($pages>1): ?><div class="paging">
    <?php $mk=function($p){$qs=$_GET;$qs['page']=$p;return e(url('/motor-baru.php?'.http_build_query($qs)));};
      for($p=1;$p<=$pages;$p++): ?><a href="<?= $mk($p) ?>" class="<?= $p==$page?'active':'' ?>"><?= $p ?></a><?php endfor; ?>
  </div><?php endif; ?>
  <?php endif; ?>
</div>
<?php include __DIR__ . '/includes/footer.php'; ?>
<script><?php echo preg_replace('/<\/script>.*/s','', file_get_contents(__DIR__.'/mobil-baru.php')); ?></script>
</body></html>
