<?php
require __DIR__ . '/includes/db.php';
include __DIR__ . '/includes/navbar.php';

/* ===== PARAM FILTER ===== */
$q = trim($_GET['q'] ?? '');
$min = (int)($_GET['min'] ?? 0);
$max = (int)($_GET['max'] ?? 0);
$ymin = (int)($_GET['ymin'] ?? 0);
$ymax = (int)($_GET['ymax'] ?? 0);
$sort = $_GET['sort'] ?? 'newest';
$page = max(1, (int)($_GET['page'] ?? 1));
$perPage = 12; $offset = ($page-1)*$perPage;

/* ===== WHERE CLAUSE (mobil baru) ===== */
$w = ["l.status='published'","v.type='car'","v.condition_type='new'"];
if ($q !== '') { $qEsc = mysqli_real_escape_string($conn,$q); $w[] = "(l.title LIKE '%$qEsc%')"; }
if ($min>0) $w[]="l.price >= $min";
if ($max>0) $w[]="l.price <= $max";
if ($ymin>0) $w[]="v.year >= $ymin";
if ($ymax>0) $w[]="v.year <= $ymax";
$whereSql = 'WHERE '.implode(' AND ',$w);

/* ===== SORT ===== */
$order="l.published_at DESC";
if ($sort==='price_asc')  $order="l.price ASC";
if ($sort==='price_desc') $order="l.price DESC";
if ($sort==='year_desc')  $order="v.year DESC, l.published_at DESC";
if ($sort==='year_asc')   $order="v.year ASC, l.published_at DESC";

/* ===== DATA + PAGING ===== */
$total=(int)mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(1) c FROM listings l JOIN vehicles v ON v.id=l.vehicle_id $whereSql"))['c'];
$pages=max(1,(int)ceil($total/$perPage));

$sql="SELECT l.id,l.title,l.price,l.city,l.province,v.year,v.type,v.condition_type,
      (SELECT url FROM vehicle_photos vp WHERE vp.vehicle_id=v.id AND vp.is_primary=1 ORDER BY sort_order LIMIT 1) photo
      FROM listings l JOIN vehicles v ON v.id=l.vehicle_id
      $whereSql ORDER BY $order LIMIT $perPage OFFSET $offset";
$res=mysqli_query($conn,$sql);
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Mobil Baru | Cremoid</title>
<style>
:root{--c-blue:#005ca8;--c-yellow:#ffcc00;--c-red:#a51616;--ink:#1b1e23;--soft:#f6f7fb;--line:#e9eaef;--shadow:0 12px 28px rgba(0,0,0,.10)}
body{margin:0;background:var(--soft);color:var(--ink);font:14.5px/1.5 system-ui,Segoe UI,Roboto,Arial}
.container{max-width:1200px;margin:0 auto;padding:0 16px}

/* HERO */
.hero{position:relative;overflow:hidden;background:#0e1624}
.hero-track{display:flex;transition:transform .6s cubic-bezier(.22,.61,.36,1)}
.hero-slide{min-width:100%;height:300px;position:relative}
@media (max-width:920px){.hero-slide{height:220px}}
.hero-slide img{position:absolute;inset:0;width:100%;height:100%;object-fit:cover}
.h-dots{position:absolute;left:0;right:0;bottom:12px;display:flex;justify-content:center;gap:8px;z-index:3}
.h-dot{width:9px;height:9px;border-radius:999px;background:rgba(255,255,255,.55);cursor:pointer}
.h-dot.active{background:#fff;width:28px;transition:width .25s;border-radius:999px}
.h-arrow{position:absolute;top:50%;transform:translateY(-50%);z-index:3;width:44px;height:44px;border-radius:12px;display:grid;place-items:center;background:rgba(0,0,0,.25);border:1px solid rgba(255,255,255,.5);cursor:pointer}
.h-prev{left:14px}.h-next{right:14px}
.h-arrow svg{fill:#fff}

/* Search centered */
.searchWrap{margin:-34px auto 22px;position:relative;z-index:5;max-width:900px;display:flex;justify-content:center}
.searchbar{flex:1;display:grid;grid-template-columns:1fr 1fr 1fr 1fr auto;gap:8px;background:#fff;border:1px solid var(--line);padding:12px;border-radius:14px;box-shadow:var(--shadow)}
@media (max-width:980px){.searchbar{grid-template-columns:1fr 1fr 1fr auto}}
@media (max-width:680px){.searchbar{grid-template-columns:1fr 1fr; row-gap:8px}}
.searchbar select,.searchbar input{border:1px solid var(--line);border-radius:10px;padding:11px}
.btn{padding:10px 14px;border-radius:10px;border:1px solid var(--line);background:#fff;text-decoration:none;color:#111;font-weight:700;cursor:pointer}
.btn.primary{background:var(--c-blue);border-color:var(--c-blue);color:#fff}
.btn.detail{background:var(--c-yellow);border-color:var(--c-yellow);color:#000;margin-top:8px;display:inline-block}

/* List */
.section{margin:24px 0}
.grid{display:grid;gap:14px;grid-template-columns:repeat(4,1fr)}
@media (max-width:980px){.grid{grid-template-columns:repeat(2,1fr)}}
.card{background:#fff;border:1px solid var(--line);border-radius:14px;overflow:hidden;transition:transform .15s,box-shadow .15s}
.card:hover{transform:translateY(-3px);box-shadow:0 12px 22px rgba(0,0,0,.08)}
.card img{width:100%;height:170px;object-fit:cover;background:#f3f5f9}
.card .b{padding:10px 12px}
.pill{display:inline-block;font-size:12px;background:#eef5ff;color:var(--c-blue);padding:3px 8px;border-radius:999px;margin-right:6px}
.price{font-weight:800}
.paging{display:flex;gap:8px;flex-wrap:wrap;justify-content:center;margin:18px 0}
.paging a{padding:8px 12px;border:1px solid var(--line);border-radius:10px;text-decoration:none;color:#111}
.paging .active{background:var(--c-blue);color:#fff;border-color:var(--c-blue)}
</style>
</head>
<body>

<!-- HERO -->
<div class="hero" id="hero">
  <div class="hero-track">
    <section class="hero-slide"><img src="<?= e(ASSET_URL) ?>/img/slide-1.jpg" alt=""></section>
    <section class="hero-slide"><img src="<?= e(ASSET_URL) ?>/img/slide-2.jpg" alt=""></section>
    <section class="hero-slide"><img src="<?= e(ASSET_URL) ?>/img/slide-3.jpg" alt=""></section>
  </div>
  <button class="h-arrow h-prev" aria-label="Prev"><svg width="20" height="20" viewBox="0 0 24 24"><path d="M15.41 7.41 14 6l-6 6 6 6 1.41-1.41L10.83 12z"/></svg></button>
  <button class="h-arrow h-next" aria-label="Next"><svg width="20" height="20" viewBox="0 0 24 24"><path d="m8.59 16.59 1.41 1.41 6-6-6-6-1.41 1.41L13.17 12z"/></svg></button>
  <div class="h-dots" id="heroDots"></div>
</div>

<!-- FILTER -->
<div class="container searchWrap">
  <form class="searchbar" method="get">
    <input type="text" name="q" value="<?= e($q) ?>" placeholder="Cari judul/merk/model">
    <input type="number" name="min" value="<?= e($min) ?>" placeholder="Harga min">
    <input type="number" name="max" value="<?= e($max) ?>" placeholder="Harga max">
    <input type="number" name="ymin" value="<?= e($ymin) ?>" placeholder="Tahun min">
    <input type="number" name="ymax" value="<?= e($ymax) ?>" placeholder="Tahun max">
    <select name="sort">
      <option value="newest"     <?= $sort==='newest'?'selected':'' ?>>Terbaru</option>
      <option value="price_asc"  <?= $sort==='price_asc'?'selected':'' ?>>Termurah</option>
      <option value="price_desc" <?= $sort==='price_desc'?'selected':'' ?>>Termahal</option>
      <option value="year_desc"  <?= $sort==='year_desc'?'selected':'' ?>>Tahun terbaru</option>
      <option value="year_asc"   <?= $sort==='year_asc'?'selected':'' ?>>Tahun terlama</option>
    </select>
    <button class="btn primary" type="submit">Terapkan</button>
  </form>
</div>

<div class="container section">
  <h2>Mobil Baru</h2>
  <?php if(!$total): ?>
    <div style="background:#fff;border:1px solid var(--line);border-radius:14px;padding:14px">Belum ada data.</div>
  <?php else: ?>
    <div class="grid">
      <?php while($r=mysqli_fetch_assoc($res)): ?>
        <div class="card">
          <img src="<?= e($r['photo'] ?: ASSET_URL.'/img/demo-car.jpg') ?>" alt="">
          <div class="b">
            <div style="margin-bottom:6px">
              <span class="pill"><?= e(strtoupper($r['type'])) ?></span>
              <span class="pill">Baru</span>
              <span class="pill"><?= (int)$r['year'] ?></span>
            </div>
            <div style="font-weight:800;line-height:1.25"><?= e($r['title']) ?></div>
            <div class="price"><?= 'Rp'.number_format($r['price'],0,',','.') ?></div>
            <div style="font-size:12px;color:#667"><?= e(trim($r['city'].($r['province']?', '.$r['province']:''))) ?></div>
            <a class="btn detail" href="<?= e(url('/detail.php?id='.$r['id'])) ?>">Detail</a>
          </div>
        </div>
      <?php endwhile; ?>
    </div>
    <?php if($pages>1): ?>
      <div class="paging">
        <?php
          $mk = function($p){ $qs=$_GET; $qs['page']=$p; return e(url('/mobil-baru.php?'.http_build_query($qs))); };
          for($p=1;$p<=$pages;$p++): ?>
          <a href="<?= $mk($p) ?>" class="<?= $p==$page?'active':'' ?>"><?= $p ?></a>
        <?php endfor; ?>
      </div>
    <?php endif; ?>
  <?php endif; ?>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
<script>
(function(){
  const root=document.getElementById('hero'),track=root.querySelector('.hero-track');
  const slides=[...root.querySelectorAll('.hero-slide')],prev=root.querySelector('.h-prev'),next=root.querySelector('.h-next');
  const dots=root.querySelector('#heroDots'); let i=0,t=null,sx=0,dx=0;
  slides.forEach((_,k)=>{let d=document.createElement('div');d.className='h-dot'+(k===0?' active':'');d.onclick=()=>go(k);dots.appendChild(d);});
  function go(n){i=(n+slides.length)%slides.length;track.style.transform=`translateX(-${i*100}%)`;[...dots.children].forEach((d,k)=>d.classList.toggle('active',k===i)); restart();}
  function restart(){ if(t)clearInterval(t); t=setInterval(()=>go(i+1),5200); }
  prev.onclick=()=>go(i-1); next.onclick=()=>go(i+1);
  root.addEventListener('mouseenter',()=>clearInterval(t)); root.addEventListener('mouseleave',()=>restart());
  root.addEventListener('touchstart',e=>{sx=e.touches[0].clientX;dx=0;},{passive:true});
  root.addEventListener('touchmove',e=>{dx=e.touches[0].clientX-sx;},{passive:true});
  root.addEventListener('touchend',()=>{ if(Math.abs(dx)>50) go(i+(dx<0?1:-1)); dx=0; });
  restart();
})();
</script>
</body>
</html>
