<?php if (!defined('BASE_URL')) require __DIR__.'/db.php'; ?>
<style>
  :root{
    --foot-bg:#0e1624; --foot-ink:#dbe2f3; --brand-blue:#005ca8; --brand-yellow:#ffcc00;
  }
  /* FOOTER fixed di bawah */
  .foot-fixed{
    position:fixed; left:0; right:0; bottom:0; z-index:60;
    background:var(--foot-bg); color:var(--foot-ink);
    box-shadow:0 -8px 24px rgba(0,0,0,.16);
  }
  .foot-fixed .container{max-width:1200px;margin:0 auto;padding:16px}
  .foot-fixed a{color:var(--foot-ink);text-decoration:none}
  .foot-fixed a:hover{color:var(--brand-yellow)}
  .foot-row{display:flex;align-items:center;justify-content:space-between;gap:12px;flex-wrap:wrap}
  .foot-brand{display:flex;align-items:center;gap:10px}
  .foot-brand img{height:26px;width:auto;display:block}
  .foot-links{display:flex;gap:14px;flex-wrap:wrap}
  @media (max-width:560px){
    .foot-row{flex-direction:column;align-items:flex-start;gap:8px}
  }
</style>

<footer class="foot-fixed" id="cremFoot">
  <div class="container">
    <div class="foot-row">
      <div class="foot-brand">
        <img src="<?= e(ASSET_URL) ?>/img/logo.png" alt="Cremoid">
        <span>© <?= date('Y') ?> Cremoid. All rights reserved.</span>
      </div>
      <nav class="foot-links" aria-label="Footer">
        <a href="<?= e(url('/artikel.php')) ?>">Artikel</a>
        <a href="<?= e(url('/pembiayaan-bpkb.php')) ?>">Pembiayaan</a>
        <a href="<?= e(url('/kontak.php')) ?>">Kontak</a>
      </nav>
    </div>
  </div>
</footer>

<script>
/* Reserve ruang untuk footer fixed tanpa ubah file halaman lain */
(function(){
  const foot = document.getElementById('cremFoot');
  const applyPad = () => {
    const h = foot.getBoundingClientRect().height;
    document.body.style.paddingBottom = h + 'px';
  };
  // jalankan awal + saat resize/orientasi berubah
  window.addEventListener('load', applyPad);
  window.addEventListener('resize', applyPad);
  window.addEventListener('orientationchange', applyPad);
})();
</script>
