<?php
// admin/artikel/edit.php — polished & centered
require __DIR__ . '/../includes/auth.php';

if (!function_exists('e')) { function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); } }
function slugify($s){ $s=strtolower(trim($s)); $s=preg_replace('~[^a-z0-9]+~','-',$s); return trim($s,'-'); }
function ensure_dir($abs){ if(!is_dir($abs)) @mkdir($abs,0777,true); return $abs; }

function upload_cover($field){
  if (empty($_FILES[$field]['name'])) return '';
  $ext = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));
  if (!in_array($ext,['jpg','jpeg','png','webp'])) return '';
  $base = realpath(__DIR__.'/..');
  $dirAbs = $base.DIRECTORY_SEPARATOR.'uploads'.DIRECTORY_SEPARATOR.'covers';
  ensure_dir($dirAbs);
  $name = 'cover_'.date('Ymd_His').'_'.bin2hex(random_bytes(3)).'.'.$ext;
  $dest = $dirAbs.DIRECTORY_SEPARATOR.$name;
  if (move_uploaded_file($_FILES[$field]['tmp_name'],$dest)) {
    return url('/admin/uploads/covers/'.$name);
  }
  return '';
}

function upload_content_images($field){
  $urls = [];
  if (!isset($_FILES[$field]) || empty($_FILES[$field]['name'])) return $urls;
  $names = $_FILES[$field]['name'];
  $tmps  = $_FILES[$field]['tmp_name'];
  $errs  = $_FILES[$field]['error'];
  if (!is_array($names)) { $names=[$names]; $tmps=[$tmps]; $errs=[$errs]; }

  $base = realpath(__DIR__.'/..');
  $dirAbs = $base.DIRECTORY_SEPARATOR.'uploads'.DIRECTORY_SEPARATOR.'articles';
  ensure_dir($dirAbs);

  for ($i=0;$i<count($names);$i++){
    if ($errs[$i]!==UPLOAD_ERR_OK || !$tmps[$i]) continue;
    $ext = strtolower(pathinfo($names[$i], PATHINFO_EXTENSION));
    if (!in_array($ext,['jpg','jpeg','png','webp','gif'])) continue;
    $name = 'img_'.date('Ymd_His').'_'.bin2hex(random_bytes(3)).'.'.$ext;
    $dest = $dirAbs.DIRECTORY_SEPARATOR.$name;
    if (move_uploaded_file($tmps[$i], $dest)) $urls[] = url('/admin/uploads/articles/'.$name);
  }
  return $urls;
}

function replace_img_placeholders($html, $urls){
  $i=1;
  foreach($urls as $u){
    $html = preg_replace_callback('/\[\[img:'.$i.'(?:\|([^\]]*))?\]\]/', function($m) use($u){
      $cap = isset($m[1]) ? trim($m[1]) : '';
      $capHtml = $cap!=='' ? '<figcaption>'.htmlspecialchars($cap,ENT_QUOTES,'UTF-8').'</figcaption>' : '';
      return '<figure><img src="'.htmlspecialchars($u,ENT_QUOTES,'UTF-8').'" alt="" style="max-width:100%">'.$capHtml.'</figure>';
    }, $html, 1);
    $i++;
  }
  // hapus placeholder yang belum terpakai
  return preg_replace('/\[\[img:\d+(?:\|[^\]]*)?\]\]/', '', $html);
}

$id = (int)($_GET['id'] ?? 0);
if($id<=0){ header('Location: '.url('/admin/artikel/index.php')); exit; }

$row = mysqli_fetch_assoc(mysqli_query($conn,"SELECT * FROM articles WHERE id=$id"));
if(!$row){ header('Location: '.url('/admin/artikel/index.php')); exit; }

$notif='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $title   = trim($_POST['title'] ?? '');
  $excerpt = trim($_POST['excerpt'] ?? '');
  $content = (string)($_POST['content'] ?? '');
  $status  = in_array($_POST['status'] ?? 'draft',['draft','published'],true) ? $_POST['status'] : 'draft';
  $slug    = slugify($title);

  if($title==='' || $content===''){
    $notif = "<div class='alert error'>Judul & konten wajib diisi.</div>";
  } else {
    $titleEsc   = mysqli_real_escape_string($conn,$title);
    $excerptEsc = mysqli_real_escape_string($conn,$excerpt);
    $slugEsc    = mysqli_real_escape_string($conn,$slug);

    // upload file
    $coverUrl = upload_cover('cover');
    $imgUrls  = upload_content_images('content_images');

    // replace placeholder -> <figure><img ...><figcaption>...</figcaption></figure>
    $contentHtml = replace_img_placeholders($content, $imgUrls);
    $contentEsc  = mysqli_real_escape_string($conn,$contentHtml);

    // set cover jika ada
    $setCover = $coverUrl ? ", cover_url='".mysqli_real_escape_string($conn,$coverUrl)."'" : "";

    // published_at: kalau published → tetap, kalau belum pernah → set NOW(); kalau draft → NULL
    $pubSet = ($status==='published') ? "published_at=IFNULL(published_at,NOW())" : "published_at=NULL";

    $ok = mysqli_query($conn,"UPDATE articles
                              SET title='$titleEsc', slug='$slugEsc', excerpt='$excerptEsc',
                                  content='$contentEsc', status='$status', $pubSet,
                                  updated_at=NOW() $setCover
                              WHERE id=$id");
    if($ok){ header('Location: '.url('/admin/artikel/index.php')); exit; }
    $notif = "<div class='alert error'>Gagal update: ".e(mysqli_error($conn))."</div>";

    // isi ulang $row agar form tetap terisi jika gagal
    $row['title']=$title; $row['excerpt']=$excerpt; $row['content']=$contentHtml; $row['status']=$status;
    if($coverUrl) $row['cover_url']=$coverUrl;
  }
}

require __DIR__ . '/../includes/header.php';
require __DIR__ . '/../includes/navbar.php';
?>
<div class="adm-card article-editor">
  <div class="card-head">
    <h2>Edit Artikel</h2>
    <div class="actions">
      <a class="btn" href="index.php">Batal</a>
      <button form="form-article" class="btn primary">Update</button>
    </div>
  </div>

  <?= $notif ?>

  <form id="form-article" method="post" enctype="multipart/form-data" class="layout">
    <!-- kiri: editor -->
    <section class="pane pane-main">
      <div class="field">
        <label>Judul</label>
        <input name="title" value="<?= e($row['title']) ?>" required placeholder="Judul artikel…">
      </div>

      <div class="field">
        <label>Ringkasan</label>
        <textarea name="excerpt" rows="3" placeholder="Ringkasan singkat…"><?= e($row['excerpt']) ?></textarea>
      </div>

      <div class="field">
        <label>Konten</label>

        <div class="toolbar" id="toolbar">
          <button type="button" data-act="h2">H2</button>
          <button type="button" data-act="h3">H3</button>
          <span class="vsep"></span>
          <button type="button" data-act="b"><b>B</b></button>
          <button type="button" data-act="i"><i>I</i></button>
          <span class="vsep"></span>
          <button type="button" data-act="ul">• List</button>
          <button type="button" data-act="ol">1. List</button>
          <button type="button" data-act="quote">❝ Quote</button>
          <button type="button" data-act="link">🔗 Link</button>
          <label class="imgpick">🖼 Gambar
            <input type="file" name="content_images[]" id="content_images" multiple accept=".jpg,.jpeg,.png,.webp,.gif">
          </label>
        </div>

        <textarea id="content" name="content" rows="18" placeholder="Tulis konten di sini. 
Tips:
- Klik 🖼 Gambar → muncul [[img:1]], [[img:2|Caption]] di posisi kursor.
- Gunakan H2/H3/B/I/Quote/List untuk format.
- Placeholder akan otomatis jadi gambar + caption saat disimpan."><?= e($row['content']) ?></textarea>

        <small class="hint">Contoh dengan caption: <code>[[img:2|Foto: Nissan GT-R di Fuji Speedway]]</code></small>
      </div>
    </section>

    <!-- kanan: publish & cover -->
    <aside class="pane pane-side">
      <div class="card">
        <div class="card-title">Publikasi</div>
        <div class="field">
          <label>Status</label>
          <select name="status">
            <option value="draft"     <?= $row['status']==='draft'?'selected':'' ?>>Draft</option>
            <option value="published" <?= $row['status']==='published'?'selected':'' ?>>Published</option>
          </select>
        </div>
        <p class="muted">Slug akan dibuat otomatis dari judul.</p>
      </div>

      <div class="card">
        <div class="card-title">Gambar Utama</div>
        <div class="field">
          <label>Cover (jpg/png/webp)</label>
          <input type="file" name="cover" accept=".jpg,.jpeg,.png,.webp">
          <?php if(!empty($row['cover_url'])): ?>
            <p class="muted" style="margin-top:6px">Cover sekarang: <a href="<?= e($row['cover_url']) ?>" target="_blank">lihat</a></p>
          <?php endif; ?>
        </div>
        <p class="muted">Opsional.</p>
      </div>

      <div class="card">
        <div class="card-title">Tips Penulisan</div>
        <ul class="tips">
          <li>Gunakan <b>H2</b> untuk sub-judul.</li>
          <li>Tambah gambar seperlunya; sertakan caption.</li>
          <li>Paragraf 3–4 baris lebih nyaman dibaca.</li>
        </ul>
      </div>
    </aside>
  </form>
</div>

<style>
/* ===== Polished editor styles (scoped) ===== */
.article-editor .card-head{display:flex;align-items:center;justify-content:space-between;margin-bottom:14px}
.article-editor .actions{display:flex;gap:8px}

/* Center & give breathing room */
.adm-card.article-editor{
  max-width: 1180px;
  margin: 0 auto;          /* center */
  padding: 24px 28px;      /* inner gutter */
}

/* two-column layout with comfortable gap */
.article-editor .layout{display:grid;grid-template-columns:2fr 1fr;gap:24px}
@media (max-width:1024px){.article-editor .layout{grid-template-columns:1fr}}
.article-editor .pane{min-width:0}
.article-editor .pane .field{margin-bottom:16px}
.article-editor .pane-side .card{margin-bottom:14px}

.article-editor label{display:block;font-weight:700;margin-bottom:6px}
.article-editor input[type=text], .article-editor input[type=file], .article-editor select, 
.article-editor textarea{
  width:100%; padding:12px; border:1px solid #e5e7eb; border-radius:12px; background:#fff
}
.article-editor textarea#content{font-family:ui-monospace, SFMono-Regular, Menlo, Consolas, monospace; line-height:1.65}
.article-editor .hint{color:#6b7280;display:block;margin-top:6px}
.article-editor .muted{color:#6b7280;font-size:13px}
.article-editor .card{background:#fff;border:1px solid #e5e7eb;border-radius:12px;padding:12px}
.article-editor .card-title{font-weight:800;margin-bottom:8px}

/* toolbar */
.article-editor .toolbar{
  position:sticky; top:70px; z-index:2;
  display:flex; gap:6px; align-items:center;
  background:#fff; border:1px solid #e5e7eb; border-radius:12px; padding:8px; margin-bottom:10px;
}
.article-editor .toolbar button, .article-editor .toolbar .imgpick{
  padding:7px 10px; border:1px solid #e5e7eb; background:#fff; border-radius:10px; cursor:pointer; font-weight:600; font-size:13px;
}
.article-editor .toolbar button:hover, .article-editor .toolbar .imgpick:hover{background:#f3f4f6}
.article-editor .toolbar .imgpick input{display:none}
.article-editor .toolbar .vsep{width:1px;height:18px;background:#e5e7eb;margin:0 4px}

/* general admin buttons (fallback) */
.btn{padding:10px 14px;border-radius:10px;border:1px solid #e5e7eb;background:#fff;cursor:pointer;font-weight:700;text-decoration:none;color:#111}
.btn.primary{background:#005ca8;border-color:#005ca8;color:#fff}
.btn:hover{filter:brightness(.97)}

/* Responsive gutters */
@media (max-width:1280px){
  .adm-card.article-editor{ padding:22px; max-width:1040px; }
}
@media (max-width:1024px){
  .adm-card.article-editor{ padding:20px; max-width:940px; }
}
@media (max-width:680px){
  .adm-card.article-editor{ padding:14px; }
  .article-editor .toolbar{ top:64px; }
}
</style>

<script>
/* ===== editor helpers ===== */
const content = document.getElementById('content');
function wrapSelection(el,before,after=''){
  const s = el.selectionStart, e = el.selectionEnd;
  const sel = el.value.slice(s,e);
  const out = before + (sel || '') + after;
  el.value = el.value.slice(0,s) + out + el.value.slice(e);
  const pos = s + out.length; el.focus(); el.setSelectionRange(pos,pos);
}
function insertAtCursor(el,txt){
  const s=el.selectionStart,e=el.selectionEnd;
  el.value = el.value.slice(0,s) + txt + el.value.slice(e);
  const pos=s+txt.length; el.focus(); el.setSelectionRange(pos,pos);
}
document.querySelectorAll('#toolbar [data-act]').forEach(b=>{
  b.addEventListener('click',()=>{
    const a=b.dataset.act;
    if(a==='h2') wrapSelection(content,'<h2>','</h2>');
    if(a==='h3') wrapSelection(content,'<h3>','</h3>');
    if(a==='b')  wrapSelection(content,'<strong>','</strong>');
    if(a==='i')  wrapSelection(content,'<em>','</em>');
    if(a==='ul') wrapSelection(content,'<ul>\n<li>','</li>\n</ul>');
    if(a==='ol') wrapSelection(content,'<ol>\n<li>','</li>\n</ol>');
    if(a==='quote') wrapSelection(content,'<blockquote>','</blockquote>');
    if(a==='link'){
      const url = prompt('URL:','https://'); if(!url) return;
      wrapSelection(content,'<a href="'+url+'" target="_blank" rel="noopener">','</a>');
    }
  });
});
document.getElementById('content_images').addEventListener('change', function onPick(){
  if(!this.files || !this.files.length) return;
  const existing = (content.value.match(/\[\[img:(\d+)/g)||[]).length;
  let n = existing + 1, tokens='';
  for(let i=0;i<this.files.length;i++) tokens += (tokens?'\n\n':'') + '[[img:'+ (n++) + ']]';
  insertAtCursor(content, tokens + '\n\n');
  // reset supaya bisa pilih lagi
  const c=this.cloneNode(true); this.parentNode.replaceChild(c,this);
  c.addEventListener('change', onPick);
});
</script>
<?php require __DIR__ . '/../includes/footer.php'; ?>
