<?php
require __DIR__ . '/includes/db.php';
include __DIR__ . '/includes/navbar.php';

// Pesan notifikasi
$notif = "";

// Handle submit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $nama     = mysqli_real_escape_string($conn, $_POST['nama']);
  $email    = mysqli_real_escape_string($conn, $_POST['email']);
  $wa       = mysqli_real_escape_string($conn, $_POST['whatsapp']);
  $pesan    = mysqli_real_escape_string($conn, $_POST['pesan']);

  $sql = "INSERT INTO kontak_masuk (nama,email,whatsapp,pesan)
          VALUES ('$nama','$email','$wa','$pesan')";
  if (mysqli_query($conn,$sql)) {
    $notif = "<div class='alert success'>✅ Terima kasih $nama, pesan Anda sudah kami terima.</div>";
  } else {
    $notif = "<div class='alert error'>❌ Gagal menyimpan pesan: ".e(mysqli_error($conn))."</div>";
  }
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Kontak Kami | Cremoid</title>
<style>
:root{
  --c-blue:#005ca8; --c-yellow:#ffcc00; --c-red:#a51616;
  --ink:#1b1e23; --soft:#f6f7fb; --line:#e9eaef; --bg:#fff;
}
body{margin:0;background:var(--soft);color:var(--ink);font:15px/1.6 system-ui,Segoe UI,Roboto,Arial}
.container{max-width:1200px;margin:0 auto;padding:20px}

/* HERO */
.hero{position:relative;height:240px;background:#001933;color:#fff;display:flex;align-items:center;justify-content:center}
.hero h1{position:relative;z-index:2;font:800 32px/1.2 system-ui;margin:0}

/* GRID */
.grid{display:grid;gap:24px;grid-template-columns:2fr 1fr;margin:40px 0}
@media(max-width:900px){.grid{grid-template-columns:1fr}}

/* FORM */
form{display:grid;gap:14px}
input,textarea{padding:12px;border:1px solid var(--line);border-radius:10px;font:15px system-ui}
textarea{min-height:120px;resize:vertical}
button{padding:12px 20px;border-radius:10px;background:var(--c-blue);color:#fff;border:none;font-weight:700;cursor:pointer}
button:hover{background:#004080}

/* INFO */
.info{background:#fff;border:1px solid var(--line);padding:20px;border-radius:14px;box-shadow:0 6px 18px rgba(0,0,0,.08)}
.info h3{margin-top:0;color:var(--c-blue)}
.info p{margin:6px 0}
.info a{color:var(--c-red);text-decoration:none}

/* MAP */
.map{margin:40px 0}
.map iframe{width:100%;height:300px;border:0;border-radius:14px}

/* NOTIF */
.alert{padding:14px;border-radius:10px;margin-bottom:20px}
.alert.success{background:#e8f9e8;color:#0a6c0a}
.alert.error{background:#ffecec;color:#a51616}
</style>
</head>
<body>

<!-- HERO -->
<section class="hero">
  <h1>Kontak Kami</h1>
</section>

<div class="container">
  <div class="grid">

    <!-- FORM -->
    <div>
      <h2>Kirim Pesan</h2>
      <?= $notif ?>
      <form method="post" action="">
        <input type="text" name="nama" placeholder="Nama Lengkap" required>
        <input type="email" name="email" placeholder="Alamat Email" required>
        <input type="text" name="whatsapp" placeholder="No. WhatsApp" required>
        <textarea name="pesan" placeholder="Tulis pesan Anda..." required></textarea>
        <button type="submit">Kirim Pesan</button>
      </form>
    </div>

    <!-- INFO -->
    <div class="info">
      <h3>Informasi Kontak</h3>
      <p><b>Alamat:</b><br>Jl. Raya Otomotif No.123, Jakarta</p>
      <p><b>Telepon:</b><br><a href="tel:+622112345678">+62 21 1234 5678</a></p>
      <p><b>WhatsApp:</b><br><a href="https://wa.me/6281234567890" target="_blank">+62 812 3456 7890</a></p>
      <p><b>Email:</b><br><a href="mailto:info@cremoid.id">info@cremoid.id</a></p>
    </div>

  </div>

  <!-- MAP -->
  <div class="map">
    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!..." allowfullscreen></iframe>
  </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
</body>
</html>
