<?php
// Set base path
$basePath = (strpos($_SERVER['PHP_SELF'], 'includes') !== false) ? '../' : './';
?>

<style>
  * {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
  }

  nav {
    background: #007b5e;
    color: white;
    position: sticky;
    top: 0;
    z-index: 999;
    width: 100%;
  }

  .nav-container {
    max-width: 1100px;
    margin: auto;
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 10px 20px;
    flex-wrap: wrap;
  }

  .nav-logo {
    font-size: 20px;
    font-weight: bold;
    color: white;
    text-decoration: none;
  }

  .nav-toggle {
    display: none;
    font-size: 26px;
    cursor: pointer;
    color: white;
  }

  .nav-menu {
    list-style: none;
    display: flex;
    gap: 20px;
  }

  .nav-menu li {
    position: relative;
  }

  .nav-menu li a {
    color: white;
    text-decoration: none;
    font-weight: bold;
    padding: 8px;
    display: block;
  }

  .nav-menu li ul {
    position: absolute;
    top: 100%;
    left: 0;
    background: white;
    display: none;
    min-width: 160px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    z-index: 9999;
  }

  .nav-menu li ul li a {
    color: #007b5e;
    font-weight: normal;
  }

  .nav-menu li:hover ul {
    display: block;
  }

  @media (max-width: 768px) {
    .nav-toggle {
      display: block;
    }

    .nav-menu {
      display: none;
      flex-direction: column;
      width: 100%;
      background: #007b5e;
      padding: 10px 0;
    }

    .nav-menu.show {
      display: flex;
    }

    .nav-menu li ul {
      position: static;
      background: #ffffff;
    }

    .nav-menu li ul li a {
      padding-left: 20px;
    }
  }
</style>

<nav>
  <div class="nav-container">
    <a href="<?php echo $basePath; ?>index.php" class="nav-logo">PASSJEK | Daftar Agen</a>
    <div class="nav-toggle" onclick="toggleMenu()">☰</div>
    <ul class="nav-menu" id="navMenu">
      <li><a href="<?php echo $basePath; ?>index.php">Beranda</a></li>
      <li><a href="<?php echo $basePath; ?>tentang.php">Tentang Kami</a></li>
      <li>
        <a href="#">Daftar Jadi Agen ▼</a>
        <ul>
          <li><a href="<?php echo $basePath; ?>agenbesar.php">1. Agen Besar</a></li>
          <li><a href="<?php echo $basePath; ?>agenkecil.php">2. Agen Kecil</a></li>
        </ul>
      </li>
      <li><a href="<?php echo $basePath; ?>galeri.php">Galeri</a></li>
      <li><a href="<?php echo $basePath; ?>kontak.php">Kontak</a></li>
    </ul>
  </div>
</nav>

<script>
  function toggleMenu() {
    document.getElementById("navMenu").classList.toggle("show");
  }
</script>
