<?php
include '../includes/db.php';
include '../includes/navbar.php';

$id = $_GET['id'] ?? 0;
$wakaf = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM wakaf WHERE id='$id'"));
if (!$wakaf) { echo "Program wakaf tidak ditemukan."; exit; }

$total = mysqli_fetch_assoc(mysqli_query($conn, "SELECT SUM(jumlah) AS total FROM donasi_wakaf WHERE id_wakaf='$id' AND status='terverifikasi'"))['total'] ?? 0;
$donatur_q = mysqli_query($conn, "SELECT * FROM donasi_wakaf WHERE id_wakaf='$id' AND status='terverifikasi'");
$jumlah_donatur = mysqli_num_rows($donatur_q);
$sisa_hari = max(0, round((strtotime($wakaf['batas_akhir']) - time()) / 86400));
$persen = $wakaf['target'] > 0 ? min(100, ($total / $wakaf['target']) * 100) : 0;
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Detail Wakaf - <?= $wakaf['judul'] ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body { font-family: sans-serif; background: #f4f4f4; margin: 0; padding: 0; }
    .container { max-width: 1000px; margin: auto; background: white; padding: 20px; border-radius: 8px; margin-top: 80px; }
    img.cover { width: 100%; border-radius: 8px; }
    h1 { font-size: 24px; color: #006400; margin-top: 20px; }
    .meta { color: #666; font-size: 14px; margin-bottom: 10px; }
    .progress { background: #eee; border-radius: 20px; height: 16px; overflow: hidden; margin: 10px 0; }
    .progress-bar { height: 100%; background: #28a745; width: <?= $persen ?>%; transition: width 0.5s ease; }
    .angka { font-weight: bold; font-size: 16px; margin-bottom: 10px; }
    .btn-wakaf {
      background: #ff7f00; color: white; padding: 10px 20px; border: none;
      border-radius: 5px; font-size: 15px; font-weight: bold; text-decoration: none; display: inline-block; margin: 10px 0;
    }
    .tab { display: inline-block; margin-right: 10px; font-weight: bold; padding: 6px 12px; background: #eee; border-radius: 6px; cursor: pointer; }
    .tab.active { background: #ff7f00; color: white; }
    .tab-content { margin-top: 20px; }
    .donatur-item { border-bottom: 1px solid #ccc; padding: 8px 0; font-size: 14px; }
    .donatur-item small { color: #777; }
    @media (max-width: 768px) {
      .container { padding: 12px; margin-top: 70px; }
    }
  </style>
  <script>
    function showTab(tab) {
      document.getElementById("detail").style.display = "none";
      document.getElementById("donatur").style.display = "none";
      document.getElementById(tab).style.display = "block";
      document.getElementById("tab-detail").classList.remove("active");
      document.getElementById("tab-donatur").classList.remove("active");
      document.getElementById("tab-" + tab).classList.add("active");
    }
  </script>
</head>
<body>

<div class="container">
  <img src="../uploads/wakaf/<?= $wakaf['gambar'] ?>" alt="gambar" class="cover">
  <h1><?= $wakaf['judul'] ?></h1>
  <div class="meta">Lokasi: <?= $wakaf['lokasi'] ?> | Lembaga: <?= $wakaf['lembaga'] ?></div>

  <div class="angka">Terkumpul: <b>Rp <?= number_format($total, 0, ',', '.') ?></b> dari Rp <?= number_format($wakaf['target'], 0, ',', '.') ?></div>
  <div class="progress"><div class="progress-bar"></div></div>
  <div class="meta"><?= $jumlah_donatur ?> Donatur | <?= $sisa_hari ?> Hari lagi</div>

  <a href="form_wakaf.php?id=<?= $wakaf['id'] ?>" class="btn-wakaf">💝 WAKAF SEKARANG</a>

  <div style="margin-top:30px;">
    <div class="tab active" id="tab-detail" onclick="showTab('detail')">Detail</div>
    <div class="tab" id="tab-donatur" onclick="showTab('donatur')">Donatur</div>
  </div>

  <div id="detail" class="tab-content">
    <?= nl2br($wakaf['deskripsi']) ?>
  </div>

  <!-- DONATUR -->
  <div id="donatur" class="tab-content" style="display:none;">
    <?php if ($jumlah_donatur == 0): ?>
      <p>Belum ada donatur.</p>
    <?php else: ?>
      <?php while($d = mysqli_fetch_assoc($donatur_q)) { ?>
        <div class="donatur-item">
          <?= htmlspecialchars($d['nama']) ?> - Rp <?= number_format($d['jumlah'],0,',','.') ?><br>
          <small><?= date('d/m/Y H:i', strtotime($d['tanggal'])) ?></small>
        </div>
      <?php } ?>
    <?php endif; ?>
  </div>

  <!-- LIKE -->
  <?php
  $liked = false;
  if (isset($_POST['like'])) {
    $user = $_SESSION['user_id'] ?? 0;
    $cek = mysqli_query($conn, "SELECT * FROM like_wakaf WHERE id_wakaf='$id' AND user_id='$user'");
    if (mysqli_num_rows($cek) == 0) {
      mysqli_query($conn, "INSERT INTO like_wakaf (id_wakaf, user_id) VALUES ('$id', '$user')");
      $liked = true;
    }
  }
  $jumlah_like = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM like_wakaf WHERE id_wakaf='$id'"));
  ?>
  <form method="post">
    <button name="like" style="background:#ff7f00; color:white; padding:8px 16px; border:none; border-radius:6px;">
      ❤️ Like (<?= $jumlah_like ?>)
    </button>
  </form>

  <!-- KOMENTAR -->
  <h3 style="margin-top:30px;">Komentar</h3>
  <form method="post" style="margin-bottom: 20px;">
    <textarea name="komentar" rows="3" placeholder="Tulis komentar..." style="width:100%; padding:10px;"></textarea>
    <button type="submit" name="kirim_komentar" style="margin-top:10px;">Kirim Komentar</button>
  </form>

  <?php
  if (isset($_POST['kirim_komentar'])) {
    $isi = mysqli_real_escape_string($conn, $_POST['komentar']);
    $user = $_SESSION['user_id'] ?? 0;
    mysqli_query($conn, "INSERT INTO komentar_wakaf (id_wakaf, user_id, isi, tanggal) VALUES ('$id', '$user', '$isi', NOW())");
    echo "<p style='color:green;'>Komentar berhasil dikirim!</p>";
  }

  $komentar = mysqli_query($conn, "SELECT k.*, u.nama FROM komentar_wakaf k LEFT JOIN users u ON u.id=k.user_id WHERE id_wakaf='$id' ORDER BY tanggal DESC");
  while ($row = mysqli_fetch_assoc($komentar)) {
    echo "<div style='border-bottom:1px solid #ccc; margin-bottom:10px;'>
            <b>{$row['nama']}</b><br>
            <small>{$row['tanggal']}</small><br>
            {$row['isi']}
          </div>";
  }
  ?>

  <!-- BAGIKAN -->
  <?php
  $url = "http://localhost/tangan_orangbaik/wakaf/detail.php?id=$id";
  $judul_url = urlencode($wakaf['judul']);
  ?>
  <div style="margin-top:40px;">
    <h3 style="margin-bottom:16px;">Bagikan Program Ini:</h3>
    <div style="display: flex; flex-wrap: wrap; gap: 12px; background: #f9f9f9; border-radius: 8px; padding: 16px; border: 1px solid #ddd;">
      <a href="https://www.facebook.com/sharer/sharer.php?u=<?= $url ?>" target="_blank"
         style="flex:1; min-width: 120px; background: #3b5998; color: white; padding: 12px; text-align: center; border-radius: 6px; text-decoration: none;">
        Facebook
      </a>
      <a href="https://api.whatsapp.com/send?text=<?= $judul_url ?> - <?= $url ?>" target="_blank"
         style="flex:1; min-width: 120px; background: #25d366; color: white; padding: 12px; text-align: center; border-radius: 6px; text-decoration: none;">
        WhatsApp
      </a>
      <a href="mailto:?subject=<?= $judul_url ?>&body=<?= $url ?>" target="_blank"
         style="flex:1; min-width: 120px; background: #f39c12; color: white; padding: 12px; text-align: center; border-radius: 6px; text-decoration: none;">
        Email
      </a>
      <a href="https://t.me/share/url?url=<?= $url ?>&text=<?= $judul_url ?>" target="_blank"
         style="flex:1; min-width: 120px; background: #0088cc; color: white; padding: 12px; text-align: center; border-radius: 6px; text-decoration: none;">
        Telegram
      </a>
    </div>
  </div>

</div>

<?php include '../includes/footer.php'; ?>
</body>
</html>
